function [sign qp_term] = line_search_cond_sparse_lowrank(Tp, Tq, Sp, Sq, X, Y, derivative, L)

% 
% f_T = norm( (Tp + Tq)' * X - Y, 'fro' )^2; 
% f_S = norm( (Sp + Sq)' * X - Y, 'fro' )^2;
% 
% % delta_Sp = trace( 2 * X' * ( (Sp + Sq)' * X - Y ) );
% % delta_Sq = delta_Sp;
% 
% fro_term = L / 2 * ( norm( Tp - Sp, 'fro' )^2 + norm( Tq - Sq, 'fro')^2 ); 
% 
% left = f_T; 
% right = f_S + trace( (Tp - Sp)' * delta ) + trace( (Tq - Sq)' * delta ) + fro_term; 
% 
% if (left <= right)
%     sign = 0;   % line search is done
% else 
%     sign = 1;    % contine to do line search
% end


m = size(Tp, 2);

f_T = 0 ; f_S = 0;

for ii = 1:m
    
    Xi = X{ii};
    f_T = f_T + norm( Xi' * (Tp(:, ii) + Tq(:, ii)) - Y{ii})^2; 
    f_S = f_S + norm( Xi' * (Sp(:, ii) + Sq(:, ii)) - Y{ii})^2; 
   
end

fro_term = L / 2 * ( norm( Tp - Sp, 'fro' )^2 + norm( Tq - Sq, 'fro' )^2 );

left = f_T; 
right = f_S + trace( (Tp - Sp)' * derivative ) + trace( (Tq - Sq)' * derivative ) + fro_term; 

qp_term = left;

if (left <= right)
    sign = 0;   % line search is done
else 
    sign = 1;    % contine to do line search
end