function L_hat = solve_trace_norm_RMTL(L, alpha)

[d1 d2] = size(L);

if (d1 > d2)
    
    [U S V] = svd(L, 0);
    
    thresholded_value = diag(S) - alpha / 2;
    
    diag_S = thresholded_value .* ( thresholded_value > 0 );
    
    L_hat = U * diag(diag_S) * V';

else 

    new_L = L';
    
    [U S V] = svd(new_L, 0);
    
    thresholded_value = diag(S) - alpha / 2;
    
    diag_S = thresholded_value .* ( thresholded_value > 0 );
    
    L_hat = U * diag(diag_S) * V';

    L_hat = L_hat';
        
end
