% L_hat, S_hat: the pair of solution points
% P, Q: the pair of searching points 

function [sign left] = line_search_cond_RMTL( L_hat, S_hat, P, Q, X, Y, derivative, gamma)

m = size(L_hat, 2);

f_T = 0 ; f_S = 0;
for ii = 1:m
    
    Xi = X{ii};
    f_T = f_T + norm( Xi' * (L_hat(:, ii) + S_hat(:, ii)) - Y{ii})^2; 
    f_S = f_S + norm( Xi' * (     P(:, ii) +     Q(:, ii)) - Y{ii})^2; 
    %f_T = norm( X' * (L_hat + S_hat) - Y, 'fro' )^2; 
    %f_S = norm( X' * (P + Q) - Y, 'fro' )^2; 

end
fro_term = gamma / 2 * ( norm( L_hat - P, 'fro' )^2 + norm( S_hat - Q, 'fro' )^2 );

left = f_T; 
right = f_S + trace( (L_hat - P)' * derivative ) + trace( (S_hat - Q)' * derivative ) + fro_term; 

if (left <= right)
    sign = 0;   % line search is done
else 
    sign = 1;    % contine to do line search
end