addpath('../../C_files/')
addpath('../../utils/')

clear;
clc;
close;

rng('default')

opts.tol = 10^-5;
opts.maxIter = 1000;
opts.tFlag = 1;
opts.init = 0;

%% Least Squares Loss
d = 300; 
n = 600;
t = 10;

X = cell(t, 1);
Y = cell(t, 1);

for i = 1: t
    X{i} = rand(n, d);
    Y{i} = sign(randn(n, 1)*5);
end

rho1 = 30;   %   rho1: low rank component L trace-norm regularization parameter
rho2 = 200;   %   rho2: sparse component S l2,1-norm sprasity controlling parameter
%profile on
[w funcVal L_hat S_hat] = Least_RMTL(X, Y, rho1, rho2, opts);
%[w c funcVal] = Logistic_L21(X, Y, rho1, opts);
fprintf('Zero Tasks: %u\n', nnz(sum(S_hat,1 )==0));
fprintf('Zero task percentage: %.4g\n', nnz(sum(S_hat, 1 )==0)/t);
%profile off
%profile viewer
plot(funcVal);
