addpath('../../C_files/')
addpath('../../utils/')

clear;
clc;
close;

rng('default')

opts.tol = 10^-5;
opts.maxIter = 1000;
opts.tFlag = 1;
opts.init = 0;

%% Least Squares Loss
d = 300; 
n = 600;
t = 10;

X = cell(t, 1);
Y = cell(t, 1);

for i = 1: t
    X{i} = rand(n, d);
    Y{i} = sign(randn(n, 1)*5);
end

rho1 = 30;  % rho3: L2,1-norm group Lasso parameter.

%profile on
[w funcVal] = Least_L21(X, Y, rho1, opts);
%[w c funcVal] = Logistic_L21(X, Y, rho1, opts);
fprintf('Zero rows: %u\n', nnz(sum(w,2 )==0));
fprintf('Zero row percentage: %.4g\n', nnz(sum(w,2 )==0)/d);
%profile off
%profile viewer
plot(funcVal);
