function x = SingVal_Projection(y, h)

n = length(y); 

clear prob; 

% c vector 
prob.c = - y;

% Q matrix
prob.qosubi = (1:n)';  
prob.qosubj = (1:n)';
prob.qoval = ones(n,1);

% constraint matrix A
prob.a = sparse( ones(1,n), 1:n, ones(1,n) );

% Lower bound of the constraint
prob.blc = h; 

% Upper bound of the constraint
prob.buc = h;

% Lower bound of variables
prob.blx = sparse( n, 1 );

% Upper bound of variables
prob.bux = ones(n, 1);  

% Setting accuracy parameters
param = []; 
accu = 10^-18;
% Primal feasibility tolerance for the primal solution
param . MSK_DPAR_INTPNT_CO_TOL_PFEAS = accu;
% Dual feasibility tolerance for the dual solution
param . MSK_DPAR_INTPNT_CO_TOL_DFEAS = accu;
% Relative primal - dual gap tolerance .
param . MSK_DPAR_INTPNT_CO_TOL_REL_GAP = accu;



[r, res] = mosekopt('minimize echo(0)', prob, param); 

% Display return code
%fprintf('Return code: %d \n', r);

% Display primal solution for the constraints
%res.sol.itr.xc' 

% Display primal solution for the variables

if ~isfield(res, 'sol')
    if isfield(res, 'rmsg')
        error('\n Mosek error: %s\n', res.rmsg);
    else
        disp(res);
        error('\n Mosek error: unknown error\n');
    end
end

x = res.sol.itr.xx;



